/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.field;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.EnumCraftingState;
import dev.compactmods.crafting.api.catalyst.ICatalystMatcher;
import dev.compactmods.crafting.api.field.IFieldListener;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import dev.compactmods.crafting.core.CCMiniaturizationRecipes;
import dev.compactmods.crafting.crafting.CraftingHelper;
import dev.compactmods.crafting.events.WorldEventHandler;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.network.FieldActivatedPacket;
import dev.compactmods.crafting.network.FieldDeactivatedPacket;
import dev.compactmods.crafting.network.FieldRecipeChangedPacket;
import dev.compactmods.crafting.network.NetworkHandler;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.projector.FieldProjectorEntity;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import dev.compactmods.crafting.recipes.blocks.RecipeBlocks;
import dev.compactmods.crafting.server.ServerConfig;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class MiniaturizationField
implements IMiniaturizationField {
    private MiniaturizationFieldSize size;
    private BlockPos center;
    private boolean loaded;
    @Nullable
    private MiniaturizationRecipe currentRecipe = null;
    private StructureTemplate matchedBlocks;
    private Set<Item> matchedCatalysts;
    @Nullable
    private ResourceLocation recipeId = null;
    private EnumCraftingState craftingState;
    private long rescanTime;
    private Level level;
    private int craftingProgress = 0;
    private final HashSet<LazyOptional<IFieldListener>> listeners = new HashSet();
    private LazyOptional<IMiniaturizationField> lazyReference = LazyOptional.empty();
    private boolean disabled = false;
    private static Disposable CHUNK_LISTENER;

    public MiniaturizationField() {
    }

    private MiniaturizationField(MiniaturizationFieldSize size, BlockPos center) {
        this.center = center;
        this.size = size;
        this.craftingState = EnumCraftingState.NOT_MATCHED;
        this.setupChunkListener();
    }

    public MiniaturizationField(CompoundTag nbt) {
        this.craftingState = EnumCraftingState.valueOf(nbt.m_128461_("state"));
        this.center = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("center"));
        this.size = MiniaturizationFieldSize.valueOf(nbt.m_128461_("size"));
        this.setupChunkListener();
        if (nbt.m_128441_("recipe")) {
            this.recipeId = new ResourceLocation(nbt.m_128461_("recipe"));
            this.craftingProgress = nbt.m_128451_("progress");
        }
        if (nbt.m_128441_("matchedBlocks")) {
            StructureTemplate t = new StructureTemplate();
            t.m_74638_(nbt.m_128469_("matchedBlocks"));
            this.matchedBlocks = t;
        } else {
            this.matchedBlocks = null;
        }
        this.disabled = nbt.m_128441_("disabled") && nbt.m_128471_("disabled");
    }

    private void setupChunkListener() {
        Set insideChunks = this.getProjectorPositions().map(ChunkPos::new).distinct().collect(Collectors.toSet());
        insideChunks.add(new ChunkPos(this.center));
        CHUNK_LISTENER = WorldEventHandler.CHUNK_CHANGES.filter(ce -> {
            boolean sameLevel = ((LevelChunk)ce.getChunk()).m_62953_().m_46472_().equals((Object)this.level.m_46472_());
            boolean watchedChunk = insideChunks.contains(ce.getChunk().m_7697_());
            return sameLevel && watchedChunk;
        }).subscribe(changed -> this.checkLoaded());
    }

    @Override
    public void dispose() {
        if (!CHUNK_LISTENER.isDisposed()) {
            CHUNK_LISTENER.dispose();
        }
    }

    public static MiniaturizationField fromSizeAndCenter(MiniaturizationFieldSize fieldSize, BlockPos center) {
        return new MiniaturizationField(fieldSize, center);
    }

    @Override
    public MiniaturizationFieldSize getFieldSize() {
        return this.size;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(BlockPos center) {
        this.center = center;
    }

    @Override
    public void setSize(MiniaturizationFieldSize size) {
        this.size = size;
    }

    @Override
    public int getProgress() {
        if (this.craftingState != EnumCraftingState.CRAFTING) {
            return 0;
        }
        return this.craftingProgress;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
        this.getRecipeFromId();
    }

    private void getRecipeFromId() {
        if (this.level != null && this.recipeId != null) {
            Optional r = this.level.m_7465_().m_44043_(this.recipeId);
            if (!r.isPresent()) {
                this.clearRecipe();
                return;
            }
            r.ifPresent(rec -> {
                this.currentRecipe = (MiniaturizationRecipe)rec;
                if (this.craftingState == EnumCraftingState.NOT_MATCHED) {
                    this.setCraftingState(EnumCraftingState.MATCHED);
                }
                this.listeners.forEach(li -> li.ifPresent(l -> {
                    l.onRecipeChanged(this, this.currentRecipe);
                    l.onRecipeMatched(this, this.currentRecipe);
                }));
            });
        } else {
            this.clearRecipe();
        }
    }

    @Override
    public Stream<BlockPos> getProjectorPositions() {
        return this.size.getProjectorLocations(this.center);
    }

    @Override
    public AABB getBounds() {
        return this.size.getBoundsAtPosition(this.center);
    }

    public Stream<BlockPos> getFilledBlocks() {
        return BlockSpaceUtil.getBlocksIn(this.getBounds()).filter(p -> !this.level.m_46859_(p)).map(BlockPos::m_7949_);
    }

    public AABB getFilledBounds() {
        BlockPos[] filled = (BlockPos[])this.getFilledBlocks().toArray(BlockPos[]::new);
        return BlockSpaceUtil.getBoundsForBlocks(filled);
    }

    public void clearBlocks() {
        this.getFilledBlocks().sorted(Comparator.comparingInt(Vec3i::m_123342_).reversed()).forEach(blockPos -> {
            this.level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 7);
            if (this.level instanceof ServerLevel) {
                ((ServerLevel)this.level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), 1, 0.0, 0.05, 0.0, 0.25);
            }
        });
    }

    @Override
    public Optional<IMiniaturizationRecipe> getCurrentRecipe() {
        return Optional.ofNullable(this.currentRecipe);
    }

    @Override
    public void clearRecipe() {
        this.recipeId = null;
        this.currentRecipe = null;
        this.craftingProgress = 0;
        this.setCraftingState(EnumCraftingState.NOT_MATCHED);
        this.listeners.forEach(l -> l.ifPresent(listener -> {
            listener.onRecipeChanged(this, this.currentRecipe);
            listener.onRecipeCleared(this);
        }));
    }

    @Override
    public EnumCraftingState getCraftingState() {
        return this.craftingState;
    }

    @Override
    public void tick() {
        if (this.level == null || this.disabled) {
            return;
        }
        if (this.rescanTime > 0L && this.level.m_46467_() >= this.rescanTime) {
            this.doRecipeScan();
            this.rescanTime = 0L;
            return;
        }
        if (this.getProjectorPositions().allMatch(arg_0 -> ((Level)this.level).m_46749_(arg_0))) {
            this.tickCrafting();
        }
    }

    private void tickCrafting() {
        AABB fieldBounds = this.getBounds();
        if (this.level == null || this.currentRecipe == null) {
            return;
        }
        switch (this.craftingState) {
            case MATCHED: {
                List<ItemEntity> catalystEntities = this.getCatalystsInField((LevelAccessor)this.level, fieldBounds.m_82400_(0.25), this.currentRecipe.getCatalyst());
                if (catalystEntities.size() <= 0) break;
                this.matchedCatalysts = catalystEntities.stream().map(t -> t.m_32055_().m_41720_()).collect(Collectors.toSet());
                if (!this.level.f_46443_) {
                    CraftingHelper.consumeCatalystItem(catalystEntities.get(0), 1);
                    this.clearBlocks();
                }
                this.setCraftingState(EnumCraftingState.CRAFTING);
                break;
            }
            case CRAFTING: {
                ++this.craftingProgress;
                if (this.craftingProgress < this.currentRecipe.getCraftingTime()) break;
                for (ItemStack is : this.currentRecipe.getOutputs()) {
                    ItemEntity itemEntity = new ItemEntity(this.level, (double)((float)this.center.m_123341_() + 0.5f), (double)((float)this.center.m_123342_() + 0.5f), (double)((float)this.center.m_123343_() + 0.5f), is);
                    this.level.m_7967_((Entity)itemEntity);
                }
                MiniaturizationRecipe completed = this.currentRecipe;
                this.clearRecipe();
                this.listeners.forEach(l -> l.ifPresent(listener -> listener.onRecipeCompleted(this, completed)));
            }
        }
    }

    public void doRecipeScan() {
        Stream<BlockPos> filledBlocks;
        if (this.level == null) {
            return;
        }
        if (((Boolean)ServerConfig.FIELD_BLOCK_CHANGES.get()).booleanValue()) {
            CompactCrafting.LOGGER.debug("Beginning field recipe scan: {}", (Object)this.center);
        }
        if (!(filledBlocks = this.getFilledBlocks()).findAny().isPresent()) {
            this.clearRecipe();
            return;
        }
        AABB filledBounds = this.getFilledBounds();
        Set recipes = this.level.m_7465_().m_44013_(CCMiniaturizationRecipes.MINIATURIZATION_RECIPE_TYPE).stream().map(r -> (MiniaturizationRecipe)r).filter(recipe -> BlockSpaceUtil.boundsFitsInside(recipe.getDimensions(), filledBounds)).collect(Collectors.toSet());
        CompactCrafting.LOGGER.trace("Matched a total of {} possible recipes.", (Object)recipes.size());
        if (recipes.isEmpty()) {
            this.clearRecipe();
            return;
        }
        this.currentRecipe = null;
        this.recipeId = null;
        this.craftingProgress = 0;
        for (MiniaturizationRecipe recipe2 : recipes) {
            RecipeBlocks blocks;
            boolean recipeMatches = recipe2.matches(blocks = RecipeBlocks.create((BlockGetter)this.level, recipe2.getComponents(), filledBounds));
            if (!recipeMatches) continue;
            this.matchedBlocks = new StructureTemplate();
            AABB fieldBounds = this.size.getBoundsAtPosition(this.center);
            BlockPos minPos = new BlockPos(fieldBounds.f_82288_, fieldBounds.f_82289_, fieldBounds.f_82290_);
            this.matchedBlocks.m_163802_(this.level, minPos, (Vec3i)this.size.getBoundsAsBlockPos(), false, null);
            this.currentRecipe = recipe2;
            this.recipeId = this.currentRecipe.getRecipeIdentifier();
            break;
        }
        this.setCraftingState(this.currentRecipe != null ? EnumCraftingState.MATCHED : EnumCraftingState.NOT_MATCHED);
        if (!this.level.f_46443_) {
            NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.level.m_46745_(this.center)), (Object)new FieldRecipeChangedPacket(this));
        }
        MiniaturizationRecipe finalMatchedRecipe = this.currentRecipe;
        this.listeners.forEach(l -> l.ifPresent(fl -> {
            fl.onRecipeChanged(this, finalMatchedRecipe);
            if (this.craftingState == EnumCraftingState.MATCHED) {
                fl.onRecipeMatched(this, finalMatchedRecipe);
            }
        }));
    }

    @Override
    public void setCraftingState(EnumCraftingState state) {
        this.craftingState = state;
    }

    private List<ItemEntity> getCatalystsInField(LevelAccessor level, AABB fieldBounds, ICatalystMatcher itemFilter) {
        List itemsInRange = level.m_45976_(ItemEntity.class, fieldBounds);
        return itemsInRange.stream().filter(ise -> itemFilter.matches(ise.m_32055_())).collect(Collectors.toList());
    }

    @Override
    public boolean isLoaded() {
        return this.loaded || this.level.f_46443_;
    }

    @Override
    public void checkLoaded() {
        CompactCrafting.LOGGER.debug("Checking loaded state.");
        this.loaded = this.level.isAreaLoaded(this.center, this.size.getProjectorDistance() + 3);
        if (this.loaded) {
            this.listeners.forEach(l -> l.ifPresent(fl -> fl.onFieldActivated(this)));
        }
    }

    @Override
    public void fieldContentsChanged() {
        this.clearRecipe();
        this.rescanTime = this.level.m_46467_() + 30L;
    }

    @Override
    public void registerListener(LazyOptional<IFieldListener> listener) {
        this.listeners.add(listener);
        listener.addListener(fl -> {
            CompactCrafting.LOGGER.debug("Removing listener: {}", fl);
            this.listeners.remove(fl);
        });
    }

    @Override
    public CompoundTag serverData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("size", this.size.name());
        nbt.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        nbt.m_128359_("state", this.craftingState.name());
        if (this.currentRecipe != null) {
            nbt.m_128359_("recipe", this.currentRecipe.getRecipeIdentifier().toString());
            nbt.m_128405_("progress", this.craftingProgress);
        }
        if (this.matchedBlocks != null) {
            nbt.m_128365_("matchedBlocks", (Tag)this.matchedBlocks.m_74618_(new CompoundTag()));
        }
        nbt.m_128379_("disabled", this.disabled);
        return nbt;
    }

    @Override
    public void setProgress(int progress) {
        this.craftingProgress = progress;
    }

    @Override
    public void setRecipe(ResourceLocation id) {
        this.recipeId = id;
        this.getRecipeFromId();
    }

    @Override
    public void handleDestabilize() {
        if (this.craftingState != EnumCraftingState.CRAFTING || this.matchedBlocks == null) {
            return;
        }
        if (this.level.f_46443_) {
            return;
        }
        boolean restoreBlocks = false;
        boolean restoreCatalyst = false;
        switch (ServerConfig.DESTABILIZE_HANDLING) {
            case RESTORE_ALL: {
                restoreBlocks = true;
                restoreCatalyst = true;
                break;
            }
            case RESTORE_BLOCKS: 
            case DESTROY_CATALYST: {
                restoreBlocks = true;
                break;
            }
            case RESTORE_CATALYST: 
            case DESTROY_BLOCKS: {
                restoreCatalyst = true;
                break;
            }
        }
        if (restoreBlocks) {
            AABB bounds = this.getBounds();
            BlockPos placeAt = new BlockPos(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_);
            this.matchedBlocks.m_74536_((ServerLevelAccessor)this.level, placeAt, placeAt, new StructurePlaceSettings(), this.level.f_46441_, 2);
        }
        if (this.currentRecipe != null) {
            ICatalystMatcher catalyst = this.currentRecipe.getCatalyst();
            if (restoreCatalyst) {
                BlockPos northLoc = this.size.getProjectorLocationForDirection(this.center, Direction.NORTH);
                for (Item cat : this.matchedCatalysts) {
                    ItemEntity ie = new ItemEntity(this.level, (double)northLoc.m_123341_(), (double)((float)this.center.m_123342_() + 1.5f), (double)northLoc.m_123343_(), new ItemStack((ItemLike)cat));
                    this.level.m_7967_((Entity)ie);
                }
            }
        }
    }

    @Override
    public LazyOptional<IMiniaturizationField> getRef() {
        return this.lazyReference;
    }

    @Override
    public void setRef(LazyOptional<IMiniaturizationField> lazyReference) {
        this.lazyReference = lazyReference;
    }

    @Override
    public void disable() {
        this.disabled = true;
        if (this.craftingState != EnumCraftingState.NOT_MATCHED) {
            this.handleDestabilize();
        }
        this.getProjectorPositions().forEach(proj -> FieldProjectorBlock.deactivateProjector(this.level, proj));
        FieldDeactivatedPacket update = new FieldDeactivatedPacket(this.size, this.center);
        NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.level.m_46745_(this.center)), (Object)update);
    }

    @Override
    public void enable() {
        this.disabled = false;
        this.fieldContentsChanged();
        this.getProjectorPositions().forEach(proj -> {
            FieldProjectorBlock.activateProjector(this.level, proj, this.size);
            BlockEntity projTile = this.level.m_7702_(proj);
            if (projTile instanceof FieldProjectorEntity) {
                ((FieldProjectorEntity)projTile).setFieldRef(this.lazyReference);
            }
        });
        FieldActivatedPacket update = new FieldActivatedPacket(this);
        NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.level.m_46745_(this.center)), (Object)update);
    }

    @Override
    public void checkRedstone() {
        this.disabled = this.getProjectorPositions().anyMatch(proj -> this.level.m_46755_(proj) > 0);
        if (this.disabled) {
            this.disable();
        } else {
            this.enable();
        }
    }

    @Override
    public boolean enabled() {
        return !this.disabled;
    }

    public Tag serializeNBT() {
        CompoundTag fieldInfo = new CompoundTag();
        fieldInfo.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        fieldInfo.m_128359_("size", this.size.name());
        fieldInfo.m_128359_("craftingState", this.craftingState.name());
        if (this.currentRecipe != null) {
            fieldInfo.m_128359_("recipe", this.currentRecipe.getRecipeIdentifier().toString());
        }
        return fieldInfo;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag fieldInfo = (CompoundTag)nbt;
            this.center = NbtUtils.m_129239_((CompoundTag)fieldInfo.m_128469_("center"));
            this.size = MiniaturizationFieldSize.valueOf(fieldInfo.m_128461_("size"));
            if (fieldInfo.m_128441_("craftingState")) {
                this.craftingState = EnumCraftingState.valueOf(fieldInfo.m_128461_("craftingState"));
            }
        }
    }
}

